#!/bin/bash

# FORMAT: VID,PID,READER_NAME_TO_LOOK_FOR;READER_NAME_TO_USE
READER_1="0x25dd,0x1101;miniLector-s;Bit4id miniLector-s"
READER_2="0x25dd,0x1201;cryptokey;Bit4id cryptokey"
READER_3="0x25dd,0x3111;miniLector;Bit4id miniLector EVO"
READER_4="0x25dd,0x2221;iAM;Bit4id iAM"
READER_5="0x25dd,0x2321;CKey4;Bit4id Token"
READER_6="0x25dd,0x2521;CKey4;Bit4id Token 2521"
READER_7="0x25dd,0x2621;CKey4;Bit4id Token 2621"
READER_8="0x25dd,0x2341;TokenME FIPS V3;Bit4id TokenME FIPS V3"
READER_9="0x25dd,0x2351;Digital DNA Key;Bit4id Digital DNA Key"
READER_10="0x25dd,0x2361;Digital-DNA Key BL;Bit4id Digital-DNA Key BL"
READER_11="0x25dd,0x2362;Digital-DNA Key;Bit4id Digital-DNA Key"
READER_12="0x25dd,0xB000;miniLector Blue;Bit4id miniLector Blue"
READER_13="0x25dd,0xB001;miniLector Blue;Bit4id miniLector Blue"
READER_14="0x25dd,0x2371;TokenME EVO v2;Bit4id TokenME EVO v2"
READER_15="0x25dd,0x3211;miniLector AIR EVO;Bit4id miniLector AIR EVO"
READER_16="0x25dd,0x3402;miniLector AIR NFC v2;Bit4id miniLector AIR NFC v2"
READER_17="0x2021,0x0001;AK910 CKey;AK910 CKey"
READER_18="0x2021,0x0011;AK910 CKey;AK910 CKey"
READER_19="0x2021,0x0101;AK910 IDONE;AK910 IDONE"
READER_20="0x25dd,0x3112;miniLector EVO v2;Bit4ID miniLector EVO v2"
READER_21="0x25dd,0x1402;TokenME EVO v2;Bit4ID TokenME EVO v2"
READER_22="0x25dd,0x1302;miniLector Pocket v2;Bit4ID miniLector Pocket v2"
READER_23="0x25dd,0x3503;miniLector AIR DI v3;Bit4ID miniLector AIR DI v3"
READER_24="0x25dd,0x3403;miniLector AIR NFC v3;Bit4ID miniLector AIR NFC v3"


for DRIVERSPATH in /usr/lib/pcsc/drivers /usr/lib/readers /usr/lib64/pcsc/drivers /usr/lib64/readers; do
    if test -f $DRIVERSPATH/ifd-ccid.bundle/Contents/Info.plist ; then
        PLIST=$DRIVERSPATH/ifd-ccid.bundle/Contents/Info.plist
    fi
done

if test -x /usr/bin/cut ; then
    CUT=/usr/bin/cut
fi
if test -x /bin/cut ; then
    CUT=/usr/bin/cut
fi
echo "cut: $CUT"
echo "PLIST: $PLIST"

if test x"$CUT" != x"" ; then
    for X in {1..24}; do
        Y=READER_$X
        VIDPID=`echo ${!Y} | cut -d ';' -f 1`
        VID=`echo ${VIDPID} | cut -d ',' -f 1`
        PID=`echo ${VIDPID} | cut -d ',' -f 2`
        NAME=`echo ${!Y} | cut -d ';' -f 2`
        NAME2=`echo ${!Y} | cut -d ';' -f 3`
        
        if test x"$PLIST" != x"" && grep -q -i "$NAME" "$PLIST" && grep -q -i "$VID" "$PLIST" && grep -q -i "$PID" "$PLIST" ; then
            echo ALREADY EXISTS: $VID $PID $NAME
        else
            echo TO ADD: $NAME $VID $PID
            VIDS="${VIDS}\t\t<string>${VID}</string>\n"
            PIDS="${PIDS}\t\t<string>${PID}</string>\n"
            NAMES="${NAMES}\t\t<string>${NAME2}</string>\n"
            ENABLED="${ENABLED}${NAME2} - ${VID}/${PID}\n"
        fi
    done


    echo -e ADDED:\\n$ENABLED

    VIDS=`echo -e $VIDS`
    PIDS=`echo -e $PIDS`
    NAMES=`echo -e $NAMES`

    OUTFILE="$1"
    if test x"$1" == x"" ; then
        OUTFILE=Info.plist
    fi
    echo "WRITING TO OUTFILE: $OUTFILE"

    cat > $OUTFILE <<EOF
<?xml version="1.0" encoding="UTF-8"?>
    <!DOCTYPE plist PUBLIC "-//Apple//DTD PLIST 1.0//EN" "http://www.apple.com/DTDs/PropertyList-1.0.dtd">
    <plist version="1.0">
    <dict>
        <key>CFBundleDevelopmentRegion</key>
        <string>English</string>
        <key>CFBundleExecutable</key>
        <string>libccid.so</string>
        <key>CFBundleIdentifier</key>
        <string>com.bit4id.ccid</string>
        <key>CFBundleInfoDictionaryVersion</key>
        <string>6.0</string>
        <key>CFBundlePackageType</key>
        <string>BNDL</string>
        <key>CFBundleShortVersionString</key>
        <string>1.0.5</string>
        <key>CFBundleSignature</key>
        <string>????</string>
        <key>CFBundleVersion</key>
        <string>0.0.1d1</string>
        <key>ifdCapabilities</key>
        <string>0x00000000</string>
        <key>ifdProtocolSupport</key>
        <string>0x00000001</string>
        <key>ifdVersionNumber</key>
        <string>0x00000001</string>
        <key>ifdLogLevel</key>
        <string>0x0003</string>
        <key>ifdDriverOptions</key>
        <string>0x0000</string>
        <key>ifdManufacturerString</key>
        <string>Bit4id</string>
        <key>ifdProductString</key>
        <string>CCID driver</string>
        <key>ifdVendorID</key>
        <array>
$VIDS
        </array>
        <key>ifdProductID</key>
        <array>
$PIDS
        </array>
        <key>ifdFriendlyName</key>
        <array>
$NAMES
        </array>
        <key>Copyright</key>
        <string>This driver is protected by terms of the GNU Lesser General Public License version 2.1, or (at your option) any later version.</string>
    </dict>
    </plist>
EOF

fi
